#!/usr/bin/env bash
set -euo pipefail

COLOR_BLUE="\033[1;34m"
COLOR_GREEN="\033[1;32m"
COLOR_YELLOW="\033[1;33m"
COLOR_RED="\033[1;31m"
COLOR_RESET="\033[0m"

info(){ echo -e "${COLOR_BLUE}➤${COLOR_RESET} $*"; }
ok(){ echo -e "${COLOR_GREEN}✓${COLOR_RESET} $*"; }
warn(){ echo -e "${COLOR_YELLOW}!${COLOR_RESET} $*"; }
err(){ echo -e "${COLOR_RED}✗${COLOR_RESET} $*"; }

require_cmd(){ command -v "$1" >/dev/null 2>&1; }

# Ensure sudo exists (most Arch installs have it)
if ! require_cmd sudo; then
  err "sudo n'est pas disponible. Exécute ce script en root ou installe sudo."
  exit 1
fi
info "Vérification de yay…"
if command -v yay >/dev/null 2>&1; then
  ok "yay est déjà installé : $(yay --version | head -n1)"
  exit 0
fi

info "Installation de yay (dépendances : git, base-devel)…"
sudo pacman -Sy --needed --noconfirm git base-devel

workdir="$(mktemp -d /tmp/yay-build-XXXX)"
info "Clonage du dépôt AUR yay-bin dans ${workdir}"
git clone --depth=1 https://aur.archlinux.org/yay-bin.git "${workdir}/yay-bin"

info "Construction et installation de yay-bin…"
pushd "${workdir}/yay-bin" >/dev/null
makepkg -si --noconfirm --needed
popd >/dev/null

if command -v yay >/dev/null 2>&1; then
  ok "yay installé avec succès : $(yay --version | head -n1)"
else
  err "L'installation de yay a échoué."
  exit 1
fi

# Optionnel : synchroniser la base de paquets
info "Synchronisation des dépôts pacman/yay…"
sudo pacman -Syy --noconfirm
ok "Terminé."
