#!/usr/bin/env bash
set -euo pipefail

COLOR_BLUE="\033[1;34m"
COLOR_GREEN="\033[1;32m"
COLOR_YELLOW="\033[1;33m"
COLOR_RED="\033[1;31m"
COLOR_RESET="\033[0m"

info(){ echo -e "${COLOR_BLUE}➤${COLOR_RESET} $*"; }
ok(){ echo -e "${COLOR_GREEN}✓${COLOR_RESET} $*"; }
warn(){ echo -e "${COLOR_YELLOW}!${COLOR_RESET} $*"; }
err(){ echo -e "${COLOR_RED}✗${COLOR_RESET} $*"; }

require_cmd(){ command -v "$1" >/dev/null 2>&1; }

# Ensure sudo exists (most Arch installs have it)
if ! require_cmd sudo; then
  err "sudo n'est pas disponible. Exécute ce script en root ou installe sudo."
  exit 1
fi
info "Installation de l'utilitaire ProtonUp-Qt (Proton-GE manager) via Flatpak…"

if ! command -v flatpak >/dev/null 2>&1; then
  info "Flatpak non présent, installation…"
  sudo pacman -S --needed --noconfirm flatpak
fi

# Ajouter le remote flathub si absent
if ! flatpak remotes | grep -q "^flathub"; then
  info "Ajout du remote flathub…"
  sudo flatpak remote-add --if-not-exists flathub https://flathub.org/repo/flathub.flatpakrepo
fi

app_id="net.davidotek.pupgui2"
if flatpak list --app | grep -q "^${app_id}\b"; then
  ok "ProtonUp-Qt est déjà installé."
else
  flatpak install -y flathub "${app_id}"
  ok "ProtonUp-Qt installé. Lance-le pour installer Proton-GE pour Steam/Lutris."
fi
