#!/usr/bin/env bash
set -euo pipefail

COLOR_BLUE="\033[1;34m"
COLOR_GREEN="\033[1;32m"
COLOR_YELLOW="\033[1;33m"
COLOR_RED="\033[1;31m"
COLOR_RESET="\033[0m"

info(){ echo -e "${COLOR_BLUE}➤${COLOR_RESET} $*"; }
ok(){ echo -e "${COLOR_GREEN}✓${COLOR_RESET} $*"; }
warn(){ echo -e "${COLOR_YELLOW}!${COLOR_RESET} $*"; }
err(){ echo -e "${COLOR_RED}✗${COLOR_RESET} $*"; }

require_cmd(){ command -v "$1" >/dev/null 2>&1; }

# Ensure sudo exists (most Arch installs have it)
if ! require_cmd sudo; then
  err "sudo n'est pas disponible. Exécute ce script en root ou installe sudo."
  exit 1
fi
info "Exécution en chaîne des scripts d'installation/configuration…"
here="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
pushd "$here" >/dev/null

# 1) yay
info "1/5 — yay"
./01-install-yay.sh || { err "Échec 01-install-yay.sh"; exit 1; }
# 2) multilib
info "2/5 — multilib"
./02-enable-multilib.sh || { err "Échec 02-enable-multilib.sh"; exit 1; }
# 3) GPU drivers
info "3/5 — drivers GPU"
./03-install-gpu-drivers.sh || { err "Échec 03-install-gpu-drivers.sh"; exit 1; }
# 4) ProtonUp-Qt
info "4/5 — ProtonUp-Qt"
./04-install-protonup-qt.sh || { err "Échec 04-install-protonup-qt.sh"; exit 1; }
# 5) Apps (Steam/Discord/Sober)
info "5/5 — Apps"
./05-install-apps.sh || { err "Échec 05-install-apps.sh"; exit 1; }

popd >/dev/null
ok "Tous les scripts ont été exécutés avec succès."
